// gcc -o main main.c xxtea.c

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/ptrace.h>
#include "xxtea.h"
#include <assert.h>
#include <stdint.h>

const char key[] = "provola0provola0\0";

const uint64_t hashes[] = {
    11230714765765817486ULL,
    215681905970914401ULL,
    9278130026369272276ULL,
    6421060296402954294ULL,
    14379616392887456874ULL,
    15492294765587140087ULL,
    8428301574377676127ULL,
    4684354224761583117ULL,
    5954764897402157862ULL,
    12887923401261906887ULL,
    14174458621082816815ULL,
    15278618443372194066ULL,
    7376991008019315892ULL,
    15254339173295742873ULL,
    1009354214030459205ULL,
    4574600664514831809ULL,
    2102414121206476067ULL,
    13310234637990092550ULL,
    18264641180120895960ULL,
    7425856735541314065ULL,
    15376742551305476023ULL,
    9797946296670303027ULL,
    1635441911037886251ULL,
    15762100890594799677ULL,
    2157268144461825508ULL,
    3175613447378979016ULL,
    14878204450056813699ULL
};

char* encrypt(const char *data, size_t len, const char *key, size_t *out_len)
{
    size_t len2;
    char *res = xxtea_encrypt(data, len, key, &len2);
    res[len2] = '\0';
    return res;
}

uint64_t from_char_ptr(char *block)
{
    return *(uint64_t *)block;
}

uint64_t hash(const char *str)
{
    // split the input string in 8 byte blocks
    size_t len = strlen(str);
    size_t blocks = (len + 3) / 4;
    size_t rest = len % 4;

    // pad the input string with zeros
    char *padded = malloc(blocks * 4);
    memcpy(padded, str, len);
    memset(padded + len, 0, blocks * 4 - len);

    // hash the input string
    uint64_t h = 0;
    for (size_t i = 0; i < blocks; i++) {
        char *enc = encrypt(padded + i * 4, 4, key, NULL);
        h ^= from_char_ptr(enc);
        free(enc);
    }

    free(padded);

    return h;
}

char input[100] = {0};
uint64_t offset = 0;

int check_char(size_t index, char character)
{
    sleep(1);

    input[offset] = character;
    offset += 1;

    uint64_t h = hash(input);

    if (h == hashes[index]) {
        return 1;
    } else {
        return 0;
    }

    // return 1;
}

int check(char *flag)
{
    for (size_t i = 0; i < strlen(flag); i++) {
        if (!check_char(i, flag[i])) {
            return 0;
        }
    }

    if (offset != 28) {
        return 0;
    }

    return 1;
}

int main()
{
    setvbuf(stdout, NULL, _IONBF, 0);
    setvbuf(stdin, NULL, _IONBF, 0);

    printf("Enter the flag: ");

    char flag[100];

    scanf("%99s", flag);

    if (ptrace(PTRACE_TRACEME, 0, 1, 0) == -1) {
        printf("No debugging allowed\n");
        return EXIT_FAILURE;
    }

    if (check(flag)) {
        printf("Yeah the flag is exactly %s\n", flag);
        return EXIT_SUCCESS;
    } else {
        printf("Mhmm I think you got the wrong flag\n");
        return EXIT_FAILURE;
    }
}